* IN THIS PART WE NEED TO DO THE FOLLOWING SELECTION
use complete_selected, clear

* We keep only those between 50 and 65
keep if dm_age_years>=50 & dm_age_years<65

* Only employed 
keep if em_employment==2

* With no missing
drop if ex_gov_red_pen==. | ex_gov_age_incr==.
drop if ex_gov_red_pen==.a | ex_gov_age_incr==.a | ex_gov_red_pen==.b | ex_gov_age_incr==.b
* I exclude Germany and Sweden, wave 4
drop if wave==4 & (country==12 | country==13)

sort country wave cl_age dm_gender
merge m:1 country wave cl_age dm_gender using weight_lfs
keep if _merge==3
drop _merge
g x=1
egen totsample=sum(x), by(country wave cl_age dm_gender)
g double pop_weight=totempl/totsample
sum pop_weight, d
egen double totempl_=sum(pop_weight), by(country wave cl_age dm_gender)
sum totempl totempl_
drop totempl_

g x2=1
replace x2=0 if country==12 | country==13
egen totsample_noDESW=sum(x2), by(country wave cl_age dm_gender)
g double pop_weight_noDESW=totempl/totsample_noDESW
sum pop_weight_noDESW if country==12 | country==13, d

g uncert_ex_gov_red_pen=(1-ex_gov_red_pen)*ex_gov_red_pen
g uncert_ex_gov_age_incr=(1-ex_gov_age_incr)*ex_gov_age_incr
g uncert_ex_gov_age_63=(1-ex_gov_age_63)*ex_gov_age_63

save descriptive, replace

****************************************
* BELIEFS OVER REFORM
****************************************
use reforms, clear
keep if samplesel==1
keep pid mergeid wave
ren pid pp
save canc, replace

use descriptive, clear
merge 1:1 mergeid wave using canc
compare pp pid
keep if _merge==3

reg ex_gov_age_incr i.wave i.country i.dm_age_years if wave==1 | wave==5
reg ex_gov_age_incr i.wave i.country i.dm_age_years if wave==1 | wave==4 [pw=pop_weight_noDESW]

reg ex_gov_red_pen i.wave i.country i.dm_age_years if wave==1 | wave==5
reg ex_gov_red_pen i.wave i.country i.dm_age_years if wave==1 | wave==4 [pw=pop_weight_noDESW]


drop if country==12 | country==13
collapse (mean) ex_gov_red_pen ex_gov_age_incr ex_gov_age_63 uncert* [pw=pop_weight_noDESW], by(wave cl_age)

replace wave=3 if wave==4
replace wave=4 if wave==5
label define wave 1 "04/05" 2 "06/07" 3 "11" 4 "13"

drop if wave==6

/* FIGURE 2 */ 
	graph twoway (line ex_gov_age_incr wave if cl_age==1, lcolor(blue) lpattern(solid) lwidth(thick)) ///
	(line ex_gov_red_pen wave if cl_age==1, lcolor(red) lpattern(longdash) lwidth(thick)) ///
	(line ex_gov_age_63 wave if cl_age==1, lcolor(green) lpattern(dash) lwidth(thick)), ///
	graphregion(color(white)) yscale(range(.25 .70)) ylabel(.30 .50 .70, labsize(large)) ytick(.30(.10).70, grid) ///
	xlabel(1 "04/05" 2 "06/07" 3 "11" 4 "13", labsize(large)) xtitle("") ///
	name("expect_1", replace) title("Age [50-54]",size(large)) ///
		legend(order(1 "NRA reform" 2 "PB reform" 3 "Work FT at age 63" ) col(3) size(medium))

	graph twoway (line ex_gov_age_incr wave if cl_age==2, lcolor(blue) lpattern(solid) lwidth(thick)) ///
	(line ex_gov_red_pen wave if cl_age==2, lcolor(red) lpattern(longdash) lwidth(thick)) ///
	(line ex_gov_age_63 wave if cl_age==2, lcolor(green) lpattern(dash) lwidth(thick)), ///
	graphregion(color(white)) yscale(range(.25 .70)) ylabel(.30 .50 .70, labsize(large)) ytick(.30(.10).70, grid) ///
	xlabel(1 "04/05" 2 "06/07" 3 "11" 4 "13", labsize(large)) legend(off) xtitle("") ///
	name("expect_2", replace) title("Age [55-59]",size(large)) nodraw

	graph twoway (line ex_gov_age_incr wave if cl_age==3, lcolor(blue) lpattern(solid) lwidth(thick)) ///
	(line ex_gov_red_pen wave if cl_age==3, lcolor(red) lpattern(longdash) lwidth(thick)), ///
	graphregion(color(white)) yscale(range(.25 .70)) ylabel(.30 .50 .70, labsize(large)) ytick(.30(.10).70, grid) ///
	xlabel(1 "04/05" 2 "06/07" 3 "11" 4 "13", labsize(large)) legend(off) xtitle("") ///
	name("expect_3", replace) title("Age [60-64]",size(large)) nodraw


grc1leg expect_1 expect_2 expect_3, legendfrom(expect_1) cols(3) name(expect_acrosswaves, replace)
graph display expect_acrosswaves, xsize(5) ysize(3)
graph export "$output/figure_2.pdf", as(pdf) replace 

